figure1 = figure('Color',[1 1 1],'rend','painters','pos',[10 10 650 475]);
annotation(figure1,'textbox',...
    [0.01 0.968 0.058 0.0440000000000003],'String',{'A'},...
    'LineStyle','none',...
    'FontSize',14,...
    'FitBoxToText','off');
annotation(figure1,'textbox',...
    [0.01 0.487 0.058 0.0440000000000001],'String','B',...
    'LineStyle','none',...
    'FontSize',14,...
    'FitBoxToText','off');
annotation(figure1,'textarrow',[0.125 0.125],...
    [0.65 0.93],'String',{'exo'},'FontSize',9);

annotation(figure1,'textarrow',[0.1 0.1],...
    [0.14 0.4],'String',{'exo'},'FontSize',9);

annotation(figure1,'textarrow',[0.56 0.56],...
    [0.14 0.4],'String',{'exo'},'FontSize',9);

%%------------------------------------------------------- top figure
fig_top = subplot(2,2,1);
set(fig_top,'FontSize',8);
t1b = title('microcal (released, aq)','FontSize',10);
t1b.FontSize = 10;
x1 = cell2mat(n_microDSC(3:end,1));
x2 = cell2mat(n_microDSC(3:end,3));
x3 = cell2mat(n_microDSC(3:end,5));

y1 = cell2mat(n_microDSC(3:end,2));
y2 = cell2mat(n_microDSC(3:end,4));
y3 = cell2mat(n_microDSC(3:end,6));

xr1 = cell2mat(r_microDSC(3:end,1));
xr2 = cell2mat(r_microDSC(3:end,3));
xr3 = cell2mat(r_microDSC(3:end,5));

yr1 = cell2mat(r_microDSC(3:end,2));
yr2 = cell2mat(r_microDSC(3:end,4));
yr3 = cell2mat(r_microDSC(3:end,6));


hold on

plot(x2(70:end,1),y2(70:end,1)+0.5,'LineWidth',1,'Color',[0 0 0]); %native
plot(xr1(70:end,1),yr1(70:end,1)-1.25,'--','LineWidth',1,'Color',[0 0 0]); %1:20
plot(xr2(70:end,1),yr2(70:end,1)-3,'-.','LineWidth',1,'Color',[0 0 0]); %1:50
plot(xr3(70:end,1),yr3(70:end,1)+1.1,':','LineWidth',1,'Color',[0 0 0]); %1:100

%ft1 = legend(fig_top,'Location','southeast',{'native','1:20','1:50','1:100'});
%legend boxoff;
lay1 = text(x2(end,1)-1.5,y2(end,1)+0.5,'native');
lay2 = text(xr1(end,1)-1.5,yr1(end,1)-1.25,'1:20');
lay3 = text(xr2(end,1)-1.5,yr2(end,1)-3,'1:50');
lay4 = text(xr3(end,1)-1.5,yr3(end,1)+1.1,'1:100');

lay1.FontSize = 8;
lay2.FontSize = 8;
lay3.FontSize = 8;
lay4.FontSize = 8;

% Create xlabel
xlabel(fig_top,'Temperature (C)','FontSize',9);
xlim(fig_top,[60 90]);
ylim(fig_top,[-.75 0.35]);
% Create ylabel
ylabel(fig_top,{'HeatFlow (mW, scaled)'},'FontSize',9);

fig_top.Position = [0.08 0.6 0.325 0.35];
hold off

%--------------------------------------------------------- right top
subfig3 = subplot(2,2,2);
set(subfig3,'FontSize',8);
title('peak integration','FontSize',10)
box off

set(subfig3,'xticklabel',{[]}) 
set(subfig3,'yticklabel',{[]}) 
axes3 = subfig3;
axes3.XColor = 'w';
axes3.YColor = 'w';
%axes3.Position = [0.05 0.05 0.825 0.9];
box off

% Create figure
r = 8;
c = 7;

columv = [0:c];
for i = 1:r
    row(i,1:8) = i; 
end

for z = [ 7 8]
line1 = line(columv(1,1:8),row(z,1:8));
line1.Color = [0 0 0];
end;
line2 = line(columv(1,1:8),[3 3 3 3 3 3 3 3]);
line2.Color = [0 0 0];

header = text(0.5,7.5,'Sample');
header.FontSize = 9;

m1 = text(0.5,6.5,'native');
m2 = text(0.5,5.5,'H (1:20)');
m3 = text(0.5,4.5,'S (1:50)');
m4 = text(0.5,3.5,'L (1:100)');
m1a = text(3,6.5,'72.80  0.01');
m2a = text(3,5.5,'73.29  0.27 (released)');
m3a = text(3,4.5,'73.37  0.40 (released)');
m4a = text(3,3.5,'72.94  0.15 (released)');

set([m1 m2 m3 m4 m1a m2a m3a m4a],'FontSize',9);
header2 = text(3,7.5,'T_m (C)');
header2.FontSize = 9;

xlim(axes3,[0 c]);
ylim(axes3,[0 r]);

subfig3.Position = [0.525 0.6 0.325 0.35];
%--------------------------------------------------------- left bottom
fig1 = subplot(2,2,3);
t1a = title('ensilicated (protected)','FontSize',8);
fig1.FontSize = 8;
hold on
x1 = cell2mat(DTA_ens(2:end,1));
y1 = cell2mat(DTA_ens(2:end,3));
y2 = cell2mat(DTA_ens(2:end,5));
ionen_x = cell2mat(ion_ens(2:end,4));
ionen_y = cell2mat(ion_ens(2:end,2));


[hAx,line1,line2] = plotyy(x1,y1,x1,y2);
ylim(hAx(1),[93 101]);
set(hAx(1),'YTick',[90 95 97.5 100 105]);
ylim(hAx(2),[-15 5]);
set(hAx(2),'YTick',[-15 -10 -5 0 5]);
hAx(3)=axes('Position',hAx(2).Position,'Color','none','XColor','none','YColor','b','YAxisLocation','right');
hlines1 = line(ionen_x,ionen_y, 'Color', 'b', 'LineStyle', '-.', 'Marker', 'none', 'Parent', hAx(3));

l1 = legend(fig1,'FontSize',8,'Location','northeast',{'TGA','DTA'});
l1a = legend(hAx(3),'Location','northwest',{'MS(18)'});
set(l1,'Box','off');
set(l1a,'Box','off','FontSize',8);
ylim(hAx(3),[min(ionen_y)/1.5 max(ionen_y)*1.2]);

hAx(1).Position = [0.08 0.1 0.325 0.35];
hAx(3).Position = [0.08 0.1 0.375 0.35];
hAx(3).FontSize = 8;
xvar1 = hAx(2).Position;
xvar2 = hAx(3).Position;
xlim(hAx(3),[0 ((200*xvar2(3))/xvar1(3))]);


hold off

%-------------------------------------------------------- right bottom
fig2 = subplot(2,2,4);
t1 = title('lyophilised (unprotected)','FontSize',8);
fig2.FontSize = 8;

hold on
x2 = cell2mat(DTA_lyop(2:end,1));
y3 = cell2mat(DTA_lyop(2:end,3));
y4 = cell2mat(DTA_lyop(2:end,5));
ionen_x1 = cell2mat(ion_lyo(1:end,1));
ionen_y1 = cell2mat(ion_lyo(1:end,2));

[hAx1,line3,line4] = plotyy(x2,y3,x2,y4);

ylim(hAx1(1),[93 101]);
set(hAx1(1),'YTick',[90 95 97.5 100 105]);
ylim(hAx1(2),[-15 5]);
set(hAx1(2),'YTick',[-15 -10 -5 0 5]);
l2 = legend(fig2,'Location','northeast',{'TGA','DTA'});
set(l2,'Box','off');
hAx1(3)=axes('Position',hAx1(2).Position,'Color','none','XColor','none','YColor','b','YAxisLocation','right');
hlines1a = line(ionen_x1,ionen_y1, 'Color', 'b', 'LineStyle', '-.', 'Marker', 'none', 'Parent', hAx1(3));

l2a = legend(hAx1(3),'Location','northwest',{'MS(18)'});
set(l2a,'Box','off','FontSize',8);
ylim(hAx1(3),[min(ionen_y1)/1.5 max(ionen_y1)*1.2]);

hAx1(1).Position = [0.535 0.1 0.325 0.35];
hAx1(3).Position = [0.535 0.1 0.4 0.35];
hAx1(3).FontSize = 8;
xvar1 = hAx1(2).Position;
xvar2 = hAx1(3).Position;
xlim(hAx1(3),[0 ((200*xvar2(3))/xvar1(3))]);
yla3 = ylabel(hAx1(3),'Ion Current (A)','Color','b','FontSize',9);

set(yla3,'Color','b','FontSize',9);

hold off
%------------------------------------------------------ styles



xlab = xlabel(fig1,'Temperature (C)');
ylabel(hAx(1),'Mass (%)');
xlab2 = xlabel(fig2,'Temperature (C)');
ylab = ylabel(hAx1(2),'DTA (V)');



line1.LineWidth = 1;
line1.Color = [0    0   0];
hlines1.LineWidth = 1.25;
hlines1a.LineWidth = 1.25;
line2.LineWidth = 1.75;
line2.Color = [1     0     0];
line3.LineWidth = 1;
line3.Color = [0    0   0];
line4.LineWidth = 1.75;
line4.Color = [1     0     0];

t1.FontSize = 10;
t1a.FontSize = 10;
xlab.FontSize = 9;
ylab.FontSize = 9;
xlab2.FontSize = 9;

hAx(1).YColor = [0    0    0];
hAx(1).FontSize = 8;
hAx(2).YColor = [1    0    0];
hAx(2).FontSize = 8;
hAx1(1).YColor = [0    0    0];
hAx1(1).FontSize = 8;
hAx1(2).YColor = [1   0    0];
hAx1(2).FontSize = 8;


%%------------------------------------------------------ positioning
l1.Position(2) = l1.Position(2)+0.025;
l1a.Position(2) = l1a.Position(2)+0.025;
l2.Position(2) = l2.Position(2)+0.025;
l2a.Position(2)= l2.Position(2)+0.025;
set(figure1,'PaperPositionMode','auto');
set(figure1,'PaperSize',[figure1.PaperPosition(3) figure1.PaperPosition(4)]);